/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class FaunaHandler {
    private static final List<SpawnListEntry> spawnCritter = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnUndergroundLarge = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnLargePrey = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnDenseWater = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnOcean = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnSessile = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnApexPred = Lists.newArrayList();

    public static List<SpawnListEntry> getSpawnableList(animalType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case animalType.CRITTER -> spawnCritter;
            case animalType.BENTHOS -> spawnSessile;
            case animalType.DENSE_WATER -> spawnDenseWater;
            case animalType.LARGE_OCEAN -> spawnOcean;
            case animalType.LARGE_HERB -> spawnLargePrey;
            case animalType.APEX_PRED -> spawnApexPred;
            case animalType.LARGE_UNDERGROUND -> spawnUndergroundLarge;
        };
    }

    public static List<SpawnListEntry> getSpawnableList(String type) {
        switch (type) {
            case "critter": {
                return spawnCritter;
            }
            case "benthos": {
                return spawnSessile;
            }
            case "water_river": {
                return spawnDenseWater;
            }
            case "water_ocean": {
                return spawnOcean;
            }
            case "herbivores": {
                return spawnLargePrey;
            }
            case "predators": {
                return spawnApexPred;
            }
            case "underground": {
                return spawnUndergroundLarge;
            }
        }
        return null;
    }

    public static enum animalType {
        CRITTER("critter"),
        BENTHOS("benthos"),
        DENSE_WATER("water_river"),
        LARGE_OCEAN("water_ocean"),
        LARGE_HERB("herbivores"),
        LARGE_UNDERGROUND("underground"),
        APEX_PRED("predators");

        public String name;

        private animalType(String name) {
            this.name = name;
        }
    }

    public static class SpawnListEntry
    extends WeightedEntry.IntrusiveBase {
        public static final Codec<SpawnListEntry> CODEC = RecordCodecBuilder.create(p_237051_0_ -> p_237051_0_.group((App)Codec.STRING.fieldOf("type").orElse((Object)"").forGetter(p_237056_0_ -> p_237056_0_.entityName), (App)Codec.INT.fieldOf("weight").orElse((Object)0).forGetter(p_237054_0_ -> p_237054_0_.itemWeight), (App)Codec.INT.fieldOf("size_min").orElse((Object)0).forGetter(p_237055_0_ -> p_237055_0_.minGroupCount), (App)Codec.INT.fieldOf("size_max").orElse((Object)0).forGetter(p_237054_0_ -> p_237054_0_.maxGroupCount)).apply((Applicative)p_237051_0_, SpawnListEntry::new));
        public String entityName;
        public EntityType<?> entityType;
        public int itemWeight;
        public int minGroupCount;
        public int maxGroupCount;

        public SpawnListEntry(String entityName, Integer weight, Integer minGroupCount, Integer maxGroupCount) {
            super(weight.intValue());
            this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityName));
            this.itemWeight = weight;
            this.minGroupCount = minGroupCount;
            this.maxGroupCount = maxGroupCount;
        }

        public SpawnListEntry(EntityType<?> entityTypeIn, int weight, int minGroupCount, int maxGroupCount) {
            super(weight);
            this.entityType = entityTypeIn;
            this.itemWeight = weight;
            this.minGroupCount = minGroupCount;
            this.maxGroupCount = maxGroupCount;
        }

        public String toString() {
            return EntityType.m_20613_(this.entityType) + "*(" + this.minGroupCount + "-" + this.maxGroupCount + "):" + this.itemWeight;
        }

        public Integer getGroupCount() {
            if (this.minGroupCount >= this.maxGroupCount) {
                return this.minGroupCount;
            }
            return new Random().nextInt(this.minGroupCount, this.maxGroupCount);
        }
    }
}

